@extends('admin.layout.master')
{{-- extra css files --}}
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('admin/app-assets/css-rtl/plugins/forms/validation/form-validation.css')}}">
    <link rel="stylesheet" type="text/css"
          href="{{asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/select2/select2.min.css') }}">
    <style>
        /*.subcategory {*/
        /*    display: none;*/
        /*}*/

        .subcategory.active {
            display: block;
        }

        .select2-container--default .select2-search--inline .select2-search__field {
            direction: rtl;
            padding-inline-start: 10px;
        }

        .select2-container {
            width: 100% !important;
        }
    </style>
@endsection
{{-- extra css files --}}

@section('content')
    <!-- // Basic multiple Column Form section start -->
    <section id="multiple-column-form">
        <div class="row match-height">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{awtTrans('تعديل مقدم خدمه افراد ')}}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <form method="POST" action="{{ route('admin.delegates.update', ['id' => $row->id]) }}"
                                  class="store form-horizontal" novalidate>
                                @csrf
                                @method('PUT')
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-12 text-center mb-3">
                                            <div class="imgMontg">
                                                <div class="dropBox">
                                                    <div class="textCenter">
                                                        <div class="imagesUploadBlock">
                                                            <label class="uploadImg">
                                                                <span><i class="feather icon-image"></i></span>
                                                                <input type="file" accept="image/*" name="avatar"
                                                                       class="imageUploader">
                                                            </label>
                                                            <div class="uploadedBlock">
                                                                <img src="{{asset('assets/uploads/users/'.$row->avatar)}}">
                                                                <button class="close"><i class="la la-times"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <span>{{awtTrans('صورة الشخصيه')}}</span>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('اسم المستخدم')}}</label>
                                                <input type="text" name="name" class="form-control"
                                                       value="{{$row->name}}"
                                                       placeholder="{{awtTrans('ادخل اسم المستخدم')}}" required
                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('رقم الجوال')}}</label>
                                                <div class="controls">
                                                    <select style="width: 20% ; position: absolute; left: 3%;" name="country_key" class="select2 form-control" required data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}" >
                                                        @foreach ($countries as $key)
                                                            <option {{$key->calling_code == $row->country_key ? 'selected' : ''}} value="{{$key->calling_code}}">{{$key->calling_code}}</option>
                                                        @endforeach
                                                    </select>
                                                    <input type="number" value="{{$row->phone}}" name="phone" class="form-control" minlength="9" placeholder="{{awtTrans('اكتب رقم الجوال')}}" required data-validation-required-message="{{awtTrans('هذا الحقل مطلوب') }}" data-validation-number-message="{{awtTrans('هذا الحقل يجب ان يكون رقما') }}" data-validation-minlength-message="{{awtTrans('هذا الحقل يجب الا يقل عن ٩ ارقام') }}">
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('البريد الالكتروني')}}</label>
                                                <input type="email" name="email" class="form-control"
                                                       value="{{$row->email}}"
                                                       placeholder="{{awtTrans('اكتب البريد الالكتروني')}}"
                                                       data-validation-email-message="{{awtTrans('هذا الحقل مطلوب بصيغة بريد الكترونى')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="password-field">{{ awtTrans('كلمة السر') }}</label>
                                                <div class="controls">
                                                    <input
                                                            type="password"
                                                            name="password"
                                                            id="password-field"
                                                            class="form-control"
                                                            minlength="8"
                                                            data-validation-minlength-message="{{ awtTrans('يجب أن تتكون كلمة السر من 8 أحرف او ارقام على الأقل') }}">
                                                </div>
                                            </div>
                                        </div>
                                        {{--                                        <div class="col-md-6">--}}
                                        {{--                                            <div class="form-group">--}}
                                        {{--                                                <label>{{awtTrans('رقم السجل التجاري')}}</label>--}}
                                        {{--                                                <input type="text" name="commercial_number" class="form-control"--}}
                                        {{--                                                       required placeholder="{{awtTrans('اكتب رقم السجل التجاري')}}"--}}
                                        {{--                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">--}}
                                        {{--                                            </div>--}}
                                        {{--                                        </div>--}}
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('رقم الايبان')}}</label>
                                                <input type="text" name="bank_iban_number" class="form-control"
                                                       required
                                                       value="{{$row->bank_iban_number}}"
                                                       placeholder="{{awtTrans('اكتب رقم الايبان')}}"
                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('رقم الحساب البنكي')}}</label>
                                                <input type="number" name="bank_account_number" class="form-control"
                                                       required
                                                       value="{{$row->bank_account_number}}"
                                                       placeholder="{{awtTrans('اكتب رقم الحساب البنكي')}}"
                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}"
                                                       data-validation-number-message="{{awtTrans('هذا الحقل يجب ان يكون رقما')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('اسم البنك')}}</label>
                                                <input type="text" name="bank_name" class="form-control" required
                                                       value="{{$row->bank_name}}"
                                                       placeholder="{{awtTrans('اكتب اسم البنك')}}"
                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{awtTrans('اسم صاحب الحساب')}}</label>
                                                <input type="text" name="bank_owner_name" class="form-control"
                                                       value="{{$row->bank_owner_name}}"
                                                       required placeholder="{{awtTrans('اكتب اسم صاحب الحساب')}}"
                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group select-group">
                                                <label>{{ awtTrans('الجنس') }}</label>
                                                <select name="gender" class="form-control" required>
                                                    <option value="">{{ awtTrans('الرجاء تحديد الجنس') }}</option>
                                                    <option value="male" @if($row->gender == 'male') selected @endif>
                                                        {{ awtTrans('ذكر') }}
                                                    </option>
                                                    <option value="female"
                                                            @if($row->gender == 'female') selected @endif>
                                                        {{ awtTrans('أنثى') }}
                                                    </option>
                                                </select>
                                                <span class="icon"><i class="bi bi-gender-ambiguous"></i></span>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('الحالة')}}</label>
                                                <div class="controls">
                                                    <select name="status" class="select2 form-control" required
                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                        <option disabled
                                                                value>{{awtTrans('اختر حالة التفعيل')}}</option>
                                                        <option {{$row->status == 'pending' ? 'selected' : ''}} value="pending">{{awtTrans('فى انتظار التفعيل ')}}</option>
                                                        <option {{$row->status == 'active' ? 'selected' : ''}} value="active">{{awtTrans('مفعل')}}</option>
                                                        <option {{$row->status == 'block' ? 'selected' : ''}} value="block">{{awtTrans(' محظور')}}</option>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('المدينة')}}</label>
                                                <div class="controls">
                                                    <select name="city_id" class="select2 form-control" required
                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                        <option value>{{awtTrans('اختر المدينه')}}</option>
                                                        @foreach ($cities as $city)
                                                            <option {{$city->id == $row->city_id ? 'selected' : ''}} value="{{$city->id}}">{{$city->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="category_id">{{ awtTrans('الاقسام الرئيسية') }}</label>
                                                <select name="category_id" class="select2 main-category" multiple="multiple" style="width: 100%;">
                                                    @foreach($categories as $category)
                                                        <option data-id="{{ $category->id }}" title="div{{ $category->id }}" value="{{ $category->id }}" class="option"{{ in_array($category->id, $selectedCategories) ? 'selected' : '' }}>
                                                                {{ $category->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('category_id')
                                                <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12 " >
                                            <div class="form-group">
                                                <label class="bold font14" for="">
                                                    قسم فرعي
                                                </label>
                                                <div class="controls">
                                                    <select name="subcategory[]"  class="select2 form-control sub-category w-100" multiple="multiple">
                                                        @foreach ($subcategories as $subcategory)
                                                            <option data-id="{{$subcategory->id}}" data-category_id="{{$subcategory->category_id}}" value="{{ $subcategory->id }}" {{ in_array($subcategory->id, $selectedSubcategories) ? 'selected' : '' }}> {{ $subcategory->name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12 " >
                                            <div class="form-group">
                                                <label class="bold font14" for="">
                                                    خدمات
                                                </label>
                                                <div class="controls">
                                                    <select name="services[]" class="select2 form-control services w-100" multiple="multiple">
                                                        @foreach ($services as $service)
                                                            <option data-sub_category_id="{{$service->subcategory_id}}" value="{{ $service->id }}" {{ in_array($service->id, $selectedServices) ? 'selected' : '' }}> {{ $service->name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group ">
                                                <label for="first-name-column">{{ __('تحديد موقعك') }}</label>
                                                <div class="controls">
                                                    <input type="hidden" id="lat" name="lat" value="{{$row->lat}}">
                                                    <input type="hidden" id="lng" name="long" value="{{$row->long}}">
                                                    <input type="text" id="address" name="address"
                                                           value="{{$row->address}}"
                                                           class="form-control"
                                                           placeholder="{{ __('تحديد موقعك') }}" required
                                                           data-validation-required-message="{{ __('admin.this_field_is_required') }}">
                                                    <div id="map" style="height: 400px; margin-top: 20px">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12 d-flex justify-content-center mt-3">
                                                <button type="submit"
                                                        class="btn btn-primary mr-1 mb-1 submit_button">{{awtTrans('تعديل')}}</button>
                                                <a href="{{ url()->previous() }}" type="reset"
                                                   class="btn btn-outline-warning mr-1 mb-1">{{awtTrans(' رجوع ')}}</a>
                                            </div>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('js')
    @include('admin.shared.addImage')
    <script src="{{asset('admin/app-assets/vendors/js/forms/validation/jqBootstrapValidation.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/forms/validation/form-validation.js')}}"></script>
    <script src="{{asset('admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>
    <script src="{{ asset('admin/select2/select2.js') }}"></script>
    @include('admin.shared.submitEditForm')
    <script>
        $(document).on('change', '.slug', function () {
            $(".slug").val($(".slug").val().replace(/\s/g, '_'))
        });

        $(document).ready(function () {
            $('.select2').select2({
                dir: 'rtl'
            });
            $('.category').select2({
                placeholder: "اختار قسم رئيسي ",
                allowClear: true,
                maximumSelectionLength: 1,
                language: {
                    maximumSelected: function () {
                        return "يمكنك اختيار عنصر واحد فقط";
                    }
                }
            });

            $('.sub-category').select2({
                placeholder: "اختار",
                allowClear: true,
            });

            $('.sub-service').select2({
                placeholder: "اختار",
                allowClear: true,
            });

            $('.select2-search__field').css('text-align', 'center');

            $('.branch').select2({
                placeholder: "اختار الاقسام ",
                allowClear: true
            })

            $('.select2-search__field').css('text-align', 'center');
        });
        $(document).ready(function() {
            $('.main-category').on('change', function() {
                $('.sub-category').val(null).trigger('change');
                $('.services').val(null).trigger('change');
                var selectedCategoryId = $(this).find('option:selected').data('id');
                $('.sub-category option').each(function() {
                    if ($(this).data('category_id') == selectedCategoryId) {
                        $(this).prop('disabled', false).show();
                    } else {
                        $(this).prop('disabled', true).hide();
                    }
                });
                $('.sub-category').select2();
            });
        });

        $(document).ready(function() {
            $('.sub-category').on('change', function() {
                var selectedSubCategoryIds = $(this).val();
                $('.services option').each(function() {
                    if (selectedSubCategoryIds.includes($(this).data('sub_category_id').toString())) {
                        $(this).prop('disabled', false).show();
                    } else {
                        $(this).prop('disabled', true).hide();
                    }
                });
                $('.services').select2();
            });

            $('.sub-category').on('select2:unselect', function(e) {
                var unselectedSubCategoryId = e.params.data.id;
                $('.services option').each(function() {
                    if ($(this).data('sub_category_id') == unselectedSubCategoryId) {
                        $(this).prop('selected', false);
                    }
                });
                $('.services').trigger('change').select2();
            });

            // Initialize the services options visibility on page load
            $('.sub-category').trigger('change');
        });


    </script>
    <script>
        function initMap() {
            // Check if existing coordinates are present in the form fields
            let existingLat = parseFloat(document.getElementById("lat").value);
            let existingLng = parseFloat(document.getElementById("lng").value);

            if (!isNaN(existingLat) && !isNaN(existingLng)) {
                // Use existing coordinates (from the database) if they are available
                const myLatlng = {
                    lat: existingLat,
                    lng: existingLng
                };
                initializeMap(myLatlng);
            } else if (navigator.geolocation) {
                // Fallback to user's current location if no coordinates exist
                navigator.geolocation.getCurrentPosition(function (p) {
                    const myLatlng = {
                        lat: p.coords.latitude,
                        lng: p.coords.longitude
                    };
                    initializeMap(myLatlng);

                    // Set the lat and lng values in the form
                    $('#lat').val(p.coords.latitude);
                    $('#lng').val(p.coords.longitude);

                    // Get the address for the current location
                    GetAddress(new google.maps.LatLng(p.coords.latitude, p.coords.longitude));
                });
            }
        }

        function initializeMap(myLatlng) {
            // Initialize the map centered on the given coordinates
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 18,
                center: myLatlng,
                mapTypeControl: false,
                streetViewControl: false,
            });

            // Set the marker at the given coordinates
            let marker = new google.maps.Marker({
                position: myLatlng,
                map: map,
                title: 'Set lat/lon values for this property',
                draggable: true,
            });

            // Update coordinates when marker is dragged
            google.maps.event.addListener(marker, 'dragend', function () {
                $('#lat').val(this.getPosition().lat());
                $('#lng').val(this.getPosition().lng());
                GetAddress(new google.maps.LatLng(this.getPosition().lat(), this.getPosition().lng()));
            });

            // Update marker and coordinates when map is clicked
            google.maps.event.addListener(map, 'click', function (event) {
                $('#lat').val(event.latLng.lat());
                $('#lng').val(event.latLng.lng());
                marker.setPosition(event.latLng);
                map.setCenter(event.latLng);
                GetAddress(new google.maps.LatLng(event.latLng.lat(), event.latLng.lng()));
            });
        }

        function GetAddress(latlng) {
            const geocoder = new google.maps.Geocoder();
            geocoder.geocode({'latLng': latlng}, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK && results[1]) {
                    $('#address').val(results[1].formatted_address);
                    $('#searchTextField').val(results[1].formatted_address);
                }
            });
        }

        function geocodeAddress(geocoder, resultsMap) {
            const address = $('#searchTextField').val();
            geocoder.geocode({address: address}, function (results, status) {
                if (status === "OK") {
                    const location = results[0].geometry.location;

                    $('#lat').val(location.lat());
                    $('#lng').val(location.lng());
                    resultsMap.setCenter(location);

                    const marker = new google.maps.Marker({
                        position: location,
                        map: resultsMap,
                        draggable: true,
                    });

                    google.maps.event.addListener(marker, 'dragend', function () {
                        $('#lat').val(this.getPosition().lat());
                        $('#lng').val(this.getPosition().lng());
                    });
                }
            });
        }

        initMap();

    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAXBff7GujmtnvMARsB5fV2RvUyA6beoII&callback=initMap&language=ar" async defer></script>

@endsection
