@extends('admin.layout.master')

@section('css')
  <link rel="stylesheet" type="text/css"
        href="{{ asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
  <link rel="stylesheet" type="text/css" href="{{asset('admin/admin_index.css')}}">
@endsection

@section('content')
  {{-- table --}}
  @php
    $variable =  request()->segment(4) ;
  @endphp
  <x-admin.search-table
          datefilter="true"
          order="true"
          extrabuttons="true"
          addbutton="{{ url('admin/delegates/create/' . $variable) }}"
          deletebutton="{{ route('admin.delegates.deleteAll') }}"
          :searchArray="[
        'name' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('الاسم') ,
        ],
        'phone' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('رقم الجوال') ,
        ] ,
        'email' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('البريد الالكترونى') ,
        ] ,
        'status' => [
            'input_type' => 'select' ,
            'rows'       => [
              '1' => [
                'name' => awtTrans(' محظور') ,
                'id' => 'block' ,
              ],
              '2' => [
                'name' => awtTrans(' فعال') ,
                'id' => 'active' ,
              ],
              '3' => [
                'name' => awtTrans(' قيد التفعيل') ,
                'id' => 'pending' ,
              ],
            ] ,
            'input_name' => awtTrans('حالة تفعيل الجوال') ,
        ] ,
        'active' => [
            'input_type' => 'select' ,
            'rows'       => [
              '1' => [
                'name' => awtTrans(' فعال') ,
                'id' => 1 ,
              ],
              '2' => [
                'name' => awtTrans(' محظور') ,
                'id' => 0 ,
              ],
            ] ,
            'input_name' => awtTrans('حالة الحظر') ,
        ] ,

    ]"
  >


    <x-slot name="extrabuttonsdiv">
      <a type="button" data-toggle="modal" data-target="#notify"
         class="btn bg-gradient-info mr-1 mb-1 waves-effect waves-light notify"
         data-id="all"><i class="feather icon-bell"></i> {{ awtTrans('ارسال اشعار') }}</a>
      <a type="button" data-toggle="modal" data-target="#mail"
         class="btn bg-gradient-success mr-1 mb-1 waves-effect waves-light mail"
         data-id="all"><i class="feather icon-mail"></i> {{ awtTrans('ارسال ايميل') }}</a>
    </x-slot>

    <x-slot name="tableContent">
      <div class="table_content_append">

      </div>
    </x-slot>
  </x-admin.search-table>

  {{-- #table --}}

  {{-- notify users model --}}
  <x-admin.NotifyAll route="{{ route('admin.delegates.notify') }}" />
  {{-- notify users model --}}

@endsection


@section('js')

  <script src="{{asset('admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
  <script src="{{asset('admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>
  {{-- delete all script --}}
  @include('admin.shared.deleteAll')
  {{-- delete all script --}}

  {{-- delete one user script --}}
  @include('admin.shared.deleteOne')
  {{-- delete one user script --}}

  {{-- notify one user or all user script --}}
  @include('admin.shared.notify')
  {{-- notify one user or all user script --}}
  @php
    $variable =  request()->segment(4) ;
  @endphp
  @include('admin.shared.filter_js', [
      'index_route' => url('admin/all/delegates/' . $variable)
  ])  <script>
    $("#end_date").change(function() {
      var startDate = document.getElementById("start_date").value;
      var endDate = document.getElementById("end_date").value;

      if ((Date.parse(endDate) < Date.parse(startDate))) {
        alert("{{ awtTrans('يجب ان يكون تاريخ النهاية بعد تاريخ البداية') }}");
        document.getElementById("end_date").value = "";
      }
    });
  </script>

  <script>
    $("#start_date").change(function() {
      var endDate = document.getElementById("end_date").value;
      var startDate = document.getElementById("start_date").value;

      if ((Date.parse(startDate) > Date.parse(endDate))) {
        alert("{{ awtTrans('يجب ان يكون تاريخ البداية قبل تاريخ النهاية') }}");
        document.getElementById("start_date").value = "";
      }
    });
  </script>

@endsection
