@extends('admin.layout.master')
{{-- extra css files --}}
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('admin/app-assets/css-rtl/plugins/forms/validation/form-validation.css')}}">
    <link rel="stylesheet" type="text/css"
          href="{{asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css')}}"
    <link rel="stylesheet" type="text/css"
          href="{{asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/select2/select2.min.css') }}">
    <style>
        #map {
            height: 400px;
            width: 100%;
        }

        /* Select2 Custom Styles */
        .contain_select2 .select2 {
            width: 100% !important;
        }

        .dark-layout .contain_select2 .select2-container--default .select2-selection--multiple {
            border: unset !important;
        }

        .dark-layout .contain_select2 .select2-search__field::placeholder {
            color: #fff;
        }

        .select2-container--default .select2-search--inline .select2-search__field {
            padding-inline-start: 10px !important;
        }

        .select2-search__field {
            direction: rtl;
        }

        .contain_select2 .select2-container--disabled .select2-search__field::placeholder {
            color: gray;
        }

        /* Phone Input Styles */
        .country_code {
            position: absolute;
            left: 10px;
        }

        .phone {
            width: 100%;
        }

        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none !important;
            -moz-appearance: none !important;
            appearance: none !important;
            margin: 0 !important;
        }

        /* Image Section Styles */
        #companyImg, #personalImg {
            display: none;
        }

        .personSection, .companySection {
            display: none;
        }

        /* Subcategory Styles */
        .subcategory {
            display: none;
        }

        .subcategory.active {
            display: block;
        }

        /* General Select2 Styles */
        .select2-container {
            width: 100% !important;
        }

        .hidden {
            display: none;
        }
    </style>
@endsection

@section('content')
    <!-- // Basic multiple Column Form section start -->
    <section id="multiple-column-form">
        <div class="row match-height">
            <div class="col-12">
                <div class="card">

                    <div class="card-header">
                        <h4 class="card-title">{{awtTrans('اضافه مقدم خدمه')}}</h4>
                    </div>

                    <div class="card-content">
                        <div class="card-body">
                            <form method="POST" action="{{route('admin.delegates.store')}}"
                                  class="store form-horizontal" novalidate>
                                @csrf
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-12 d-flex justify-content-center">
                                            <div class="col-lg-6 col-md-6">
                                                <div class="imgMontg text-center">
                                                    <div class="dropBox">
                                                        <div class="textCenter">
                                                            <div class="imagesUploadBlock">
                                                                <label class="uploadImg">
                                                                    <span><i class="feather icon-image"></i></span>
                                                                    <input type="file" accept="image/*" name="avatar"
                                                                           class="imageUploader">
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <span>{{ awtTrans('صورة الشخصية ') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('اسم المستخدم')}}</label>
                                                <div class="controls">
                                                    <input type="text" name="name" class="form-control"
                                                           placeholder="{{awtTrans('اكتب اسم المستخدم')}}" required
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('رقم الجوال')}}</label>
                                                <div class="controls">
                                                    <select style="width: 20% ; position: absolute; left: 3%;"
                                                            name="country_key" class="select2 form-control" required
                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                        @foreach ($countries as $key)
                                                            <option value="{{$key->calling_code}}">{{$key->calling_code}}</option>
                                                        @endforeach
                                                    </select>
                                                    <input type="number" name="phone" class="form-control"
                                                           placeholder="{{awtTrans('اكتب رقم الجوال')}}" required
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}"
                                                           data-validation-number-message="{{awtTrans('يجب ان يكون رقم الجوال رقما صحيحا.')}}"
                                                    >
                                                </div>

                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('البريد الالكتروني')}}</label>
                                                <div class="controls">
                                                    <input type="email" name="email" class="form-control"
                                                           placeholder="{{awtTrans('اكتب البريد الالكتروني')}}"
                                                           data-validation-email-message="{{awtTrans('هذا الحقل مطلوب بصيغة بريد الكترونى')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="password-field">{{ awtTrans('كلمة السر') }}</label>
                                                <div class="controls">
                                                    <input
                                                            type="password"
                                                            name="password"
                                                            id="password-field"
                                                            class="form-control"
                                                            minlength="8"
                                                            required
                                                            data-validation-required-message="{{ awtTrans('هذا الحقل مطلوب') }}"
                                                            data-validation-minlength-message="{{ awtTrans('يجب أن تتكون كلمة السر من 8 أحرف على الأقل') }}">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city_id">{{awtTrans('المدينه ')}}</label>
                                                <div class="controls">
                                                    <select name="city_id" id="city_id" class="select2 form-control"
                                                            required
                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                        <option value="">{{awtTrans('اختر المدينة ')}}</option>
                                                        @foreach ($cities as $city)
                                                            <option value="{{$city->id}}">{{$city->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{awtTrans('النوع')}}</label>
                                                <div class="controls">
                                                    <select name="gender" class="select2 form-control" required
                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                        <option value>{{awtTrans('اختر النوع ')}}</option>
                                                        <option value="male">{{awtTrans('ذكر')}}</option>
                                                        <option value="female">{{awtTrans('انثي')}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="bank_name">{{awtTrans('اسم البنك')}}</label>
                                                <div class="controls">
                                                    <input type="text" name="bank_name" id="bank_name"
                                                           class="form-control" required
                                                           placeholder="{{awtTrans('اكتب اسم البنك')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="account_holder_name">{{awtTrans('اسم صاحب الحساب')}}</label>
                                                <div class="controls">
                                                    <input type="text" name="bank_owner_name"
                                                           id="bank_owner_name" class="form-control" required
                                                           placeholder="{{awtTrans('اكتب اسم صاحب الحساب')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="bank_iban_number">{{awtTrans('رقم الآيبان')}}</label>
                                                <div class="controls">
                                                    <input type="text" name="bank_iban_number" id="bank_iban_number"
                                                           class="form-control" required
                                                           placeholder="{{awtTrans('اكتب رقم الآيبان')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="bank_acc_number">{{awtTrans('رقم الحساب البنكي')}}</label>
                                                <div class="controls">
                                                    <input type="number" name="bank_account_number"
                                                           id="bank_account_number"
                                                           class="form-control" required
                                                           placeholder="{{awtTrans('اكتب رقم الحساب البنكي')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}"
                                                           data-validation-number-message="{{awtTrans('هذا الحقل يجب ان يكون رقما')}}">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="category_id">{{ awtTrans('الاقسام الرئيسية') }}</label>
                                                <select name="category_id" class="select2 main-category"
                                                        multiple="multiple" style="width: 100%;">
                                                    @foreach($categories as $category)
                                                        <option data-id="{{ $category->id }}"
                                                                value="{{ $category->id }}">
                                                            {{ $category->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('category_id')
                                                <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label class="bold font14" for="subcategory">
                                                    قسم فرعي
                                                </label>
                                                <div class="controls">
                                                    <select name="subcategory[]"
                                                            class="select2 form-control sub-category w-100"
                                                            multiple="multiple">
                                                        @foreach ($subcategories as $subcategory)
                                                            <option data-id="{{ $subcategory->id }}"
                                                                    data-category_id="{{ $subcategory->category_id }}"
                                                                    value="{{ $subcategory->id }}">
                                                                {{ $subcategory->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label class="bold font14" for="services">
                                                    خدمات
                                                </label>
                                                <div class="controls">
                                                    <select name="services[]"
                                                            class="select2 form-control services w-100"
                                                            multiple="multiple">
                                                        @foreach ($services as $service)
                                                            <option data-sub_category_id="{{ $service->subcategory_id }}"
                                                                    value="{{ $service->id }}">
                                                                {{ $service->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">{{ __('تحديد موقعك') }}</label>
                                                <div class="controls">
                                                    <input type="hidden" id="lat" name="lat">
                                                    <input type="hidden" id="lng" name="long">
                                                    <input type="text" id="address" name="address"
                                                           class="form-control"
                                                           placeholder="{{ __('تحديد موقعك') }}" required
                                                           data-validation-required-message="{{ __('admin.this_field_is_required') }}">
                                                    <div id="map"></div>
                                                </div>
                                            </div>

                                            <div class="col-12 d-flex justify-content-center mt-3">
                                                <button type="submit"
                                                        class="btn btn-primary mr-1 mb-1 submit_button">{{awtTrans('اضافة')}}</button>
                                                <a href="{{ url()->previous() }}" type="reset"
                                                   class="btn btn-outline-warning mr-1 mb-1">{{awtTrans(' رجوع ')}}</a>
                                            </div>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('js')
    <script src="{{asset('admin/app-assets/vendors/js/forms/validation/jqBootstrapValidation.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/forms/validation/form-validation.js')}}"></script>
    <script src="{{asset('admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>
    <script src="{{ asset('admin/select2/select2.js') }}"></script>
    <script>
        $(document).ready(function () {
            $('.select2').select2({dir: 'rtl'});

            $('.main-category').on('change', function () {
                $('.sub-category').val(null).trigger('change');
                $('.services').val(null).trigger('change');
                var selectedCategoryId = $(this).find('option:selected').data('id');
                $('.sub-category option').each(function () {
                    if ($(this).data('category_id') == selectedCategoryId) {
                        $(this).prop('disabled', false).show();
                    } else {
                        $(this).prop('disabled', true).hide();
                    }
                });
                $('.sub-category').select2();
            });

            $('.sub-category').on('change', function () {
                var selectedSubCategoryIds = $(this).val();
                $('.services option').each(function () {
                    if (selectedSubCategoryIds.includes($(this).data('sub_category_id').toString())) {
                        $(this).prop('disabled', false).show();
                    } else {
                        $(this).prop('disabled', true).hide();
                    }
                });
                $('.services').select2();
            });

            $('.sub-category').on('select2:unselect', function (e) {
                var unselectedSubCategoryId = e.params.data.id;
                $('.services option').each(function () {
                    if ($(this).data('sub_category_id') == unselectedSubCategoryId) {
                        $(this).prop('selected', false);
                    }
                });
                $('.services').trigger('change').select2();
            });
        });
    </script>
    <script>
        function initMap() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (p) {
                    const myLatlng = {
                        lat: p.coords.latitude,
                        lng: p.coords.longitude
                    };

                    const map = new google.maps.Map(document.getElementById("map"), {
                        zoom: 18,
                        center: myLatlng,
                        mapTypeControl: false,
                        streetViewControl: false,

                    });

                    $('#lat').val(p.coords.latitude)
                    $('#lng').val(p.coords.longitude)
                    GetAddress(new google.maps.LatLng(p.coords.latitude, p.coords.longitude))

                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(p.coords.latitude, p.coords.longitude),
                        map: map,
                        title: 'Set lat/lon values for this property',
                        draggable: true,
                        streetViewControl: false,

                    });

                    google.maps.event.addListener(marker, 'dragend', function (event) {
                        document.getElementById("lat").value = this.getPosition().lat();
                        document.getElementById("lng").value = this.getPosition().lng();
                        GetAddress(new google.maps.LatLng(marker.getPosition().lat(), marker.getPosition().lng()))
                    });

                    google.maps.event.addListener(map, 'click', function (event) {
                        $('#lat').val(event.latLng.lat())
                        $('#lng').val(event.latLng.lng())
                        marker.setPosition(event.latLng);
                        map.setCenter(event.latLng);
                        map.setZoom(18);
                        GetAddress(new google.maps.LatLng(event.latLng.lat(), event.latLng.lng()))
                    });
                });
            }
        }

        function GetAddress(latlng) {
            var geocoder = geocoder = new google.maps.Geocoder();
            geocoder.geocode({
                'latLng': latlng
            }, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    if (results[1]) {
                        document.getElementById("address").value = results[1].formatted_address;
                    }
                }
            });
        }

        function geocodeAddress(geocoder, resultsMap) {
            const address = document.getElementById("searchTextField").value;
            geocoder.geocode({
                address: address
            }, (results, status) => {
                if (status === "OK") {

                    $('#lat').val(results[0].geometry.location.lat())
                    $('#lng').val(results[0].geometry.location.lng())

                    resultsMap.setCenter(results[0].geometry.location);

                    const myLatlng = {
                        lat: results[0].geometry.location.lat(),
                        lng: results[0].geometry.location.lng()
                    };
                    const map = new google.maps.Map(document.getElementById("map"), {
                        zoom: 18,
                        center: myLatlng,
                        mapTypeControl: false,
                        streetViewControl: false,

                    });
                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(results[0].geometry.location.lat(), results[0]
                            .geometry.location.lng()),
                        map: map,
                        title: 'Set lat/lon values for this property',
                        draggable: true,
                        streetViewControl: false,
                    });

                    google.maps.event.addListener(marker, 'dragend', function (event) {
                        document.getElementById("latitude").value = this.getPosition().lat();
                        document.getElementById("longitude").value = this.getPosition().lng();
                    });

                    google.maps.event.addListener(map, 'click', function (event) {
                        $('#lat').val(event.latLng.lat())
                        $('#lng').val(event.latLng.lng())
                        marker.setPosition(event.latLng);
                        map.setCenter(event.latLng);
                        map.setZoom(18);
                    });
                } else {
                }
            });
        }

        initMap();
        $(document).ready(function () {
            $('.js-example-basic-single').select2({
                templateResult: function (data, container) {
                    if (!data.element) {
                        return data.text;
                    }

                    var $element = $(
                        '<span><img width="20px" height="20px" src="' + $(data.element).data('image') + '" class="img-flag" /> ' + data.text + '</span>'
                    );

                    return $element;
                }
            });


            {{--$(document).on('change','#select_category',function(e){--}}
            {{--    e.preventDefault();--}}
            {{--    let categoryId = $(this).val();--}}
            {{--    $.ajax({--}}
            {{--        url: "{{route('admin.category.services')}}",--}}
            {{--        method: 'get',--}}
            {{--        data: { category_id : categoryId },--}}
            {{--        dataType:'json',--}}
            {{--        success: function(response){--}}
            {{--            $('#category_services').empty();--}}
            {{--            for(service of response.data){--}}
            {{--                $('#category_services').append(`<option value="${service.id}">${service.name.{{lang()}}}</option>'`);--}}
            {{--            }--}}
            {{--        },--}}
            {{--    });--}}

            {{--});--}}

            $('#select_deposit_status').on('change', function () {
                if ($(this).val() == 0) {
                    $('#deposit').attr('disabled', 'disabled')
                    $('#deposit').val('')
                } else {
                    $('#deposit').removeAttr('disabled')
                }
            })
        });

        $(document).on('change', '#country_id', function () {
            $('#city_id').html(`
                <option value>{{awtTrans('اختر المدينة ')}}</option>
            `);
        });


    </script>

    <script>
        $(document).keypress(
            function (event) {
                if (event.which == '13') {
                    event.preventDefault();
                }
            });

        function initMap() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (p) {
                    const myLatlng = {
                        lat: p.coords.latitude,
                        lng: p.coords.longitude
                    };

                    const map = new google.maps.Map(document.getElementById("map"), {
                        zoom: 18,
                        center: myLatlng,
                        mapTypeControl: false,
                        streetViewControl: false,

                    });

                    $('#lat').val(p.coords.latitude)
                    $('#lng').val(p.coords.longitude)
                    GetAddress(new google.maps.LatLng(p.coords.latitude, p.coords.longitude))


                    // var input = document.getElementById('searchTextField');
                    // var autocomplete = new google.maps.places.Autocomplete(input);
                    // const geocoder = new google.maps.Geocoder();

                    // document.getElementById("searchTextField").addEventListener("keyup", () => {
                    //     geocodeAddress(geocoder, map);
                    // });

                    // document.getElementById("searchTextField").addEventListener("change", () => {
                    //     geocodeAddress(geocoder, map);
                    // });

                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(p.coords.latitude, p.coords.longitude),
                        map: map,
                        title: 'Set lat/lon values for this property',
                        draggable: true,
                        streetViewControl: false,

                    });

                    google.maps.event.addListener(marker, 'dragend', function (event) {
                        document.getElementById("lat").value = this.getPosition().lat();
                        document.getElementById("lng").value = this.getPosition().lng();
                        GetAddress(new google.maps.LatLng(marker.getPosition().lat(), marker.getPosition().lng()))
                    });

                    google.maps.event.addListener(map, 'click', function (event) {
                        $('#lat').val(event.latLng.lat())
                        $('#lng').val(event.latLng.lng())
                        marker.setPosition(event.latLng);
                        map.setCenter(event.latLng);
                        map.setZoom(18);
                        GetAddress(new google.maps.LatLng(event.latLng.lat(), event.latLng.lng()))
                    });
                });
            }
        }

        function GetAddress(latlng) {
            var geocoder = geocoder = new google.maps.Geocoder();
            geocoder.geocode({'latLng': latlng}, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    if (results[1]) {
                        $("textarea#text").value = results[1].formatted_address;
                        document.getElementById("address").value = results[1].formatted_address;
                        document.getElementById("searchTextField").value = results[1].formatted_address;
                    }
                }
            });
        }

        function geocodeAddress(geocoder, resultsMap) {
            const address = document.getElementById("searchTextField").value;
            geocoder.geocode({address: address}, (results, status) => {
                if (status === "OK") {

                    $('#lat').val(results[0].geometry.location.lat())
                    $('#lng').val(results[0].geometry.location.lng())

                    resultsMap.setCenter(results[0].geometry.location);


                    const myLatlng = {
                        lat: results[0].geometry.location.lat(),
                        lng: results[0].geometry.location.lng()
                    };
                    const map = new google.maps.Map(document.getElementById("map"), {
                        zoom: 18,
                        center: myLatlng,
                        mapTypeControl: false,
                        streetViewControl: false,

                    });
                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(results[0].geometry.location.lat(), results[0].geometry.location.lng()),
                        map: map,
                        title: 'Set lat/lon values for this property',
                        draggable: true,
                        streetViewControl: false,
                    });

                    google.maps.event.addListener(marker, 'dragend', function (event) {
                        document.getElementById("latitude").value = this.getPosition().lat();
                        document.getElementById("longitude").value = this.getPosition().lng();
                    });

                    google.maps.event.addListener(map, 'click', function (event) {
                        $('#lat').val(event.latLng.lat())
                        $('#lng').val(event.latLng.lng())
                        marker.setPosition(event.latLng);
                        map.setCenter(event.latLng);
                        map.setZoom(18);
                    });
                } else {
                    // alert("Geocode was not successful for the following reason: " + status);
                }
            });
        }

        initMap();
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAXBff7GujmtnvMARsB5fV2RvUyA6beoII&callback=initMap&language=ar"
            async defer></script>


    {{-- #Maps --}}

    {{-- show selected image script --}}
    @include('admin.shared.addImage')
    {{-- show selected image script --}}

    {{-- submit add form script --}}
    @include('admin.shared.submitAddForm')
    {{-- submit add form script --}}
@endsection
