@extends('admin.layout.master')

@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{asset('admin/admin_index.css')}}">

@endsection

@section('content')
    {{-- table --}}
    <x-admin.search-table
            datefilter="true"
            order="true"
            extrabuttons="true"
            deletebutton="{{ route('admin.delegates.deleteAll') }}"
            :searchArray="[
        'name' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('الاسم') ,
        ],
        'phone' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('رقم الجوال') ,
        ] ,
        'email' => [
            'input_type' => 'text' ,
            'input_name' => awtTrans('البريد الالكترونى') ,
        ] ,

    ]"
    >


        <x-slot name="extrabuttonsdiv">

        </x-slot>

        <x-slot name="tableContent">
            <div class="table_content_append">

            </div>
        </x-slot>
    </x-admin.search-table>

    {{-- #table --}}

    {{-- notify users model --}}
{{--    <x-admin.NotifyAll route="{{ route('admin.clients.notify') }}" />--}}
    {{-- notify users model --}}

@endsection


@section('js')
    <script src="{{asset('admin/app-assets/vendors/js/forms/validation/jqBootstrapValidation.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/forms/validation/form-validation.js')}}"></script>
    <script src="{{asset('admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{asset('admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>
    {{-- delete all script --}}
{{--    @include('admin.shared.deleteAll')--}}
    {{-- delete all script --}}

    {{-- delete one user script --}}
{{--    @include('admin.shared.deleteOne')--}}
    {{-- delete one user script --}}

    {{-- notify one user or all user script --}}
{{--    @include('admin.shared.notify')--}}
    @include('admin.shared.filter_js' , [ 'index_route' => url('admin/delegates-have-balance')])
    <script>

        $(document).on('click', '.settlement', function (){
            var userData = $(this).data('user');
            $('input[name="user_id"]').val(userData.id);
            $('input[name="balance"]').val(userData.wallet);
            $('#phoneForm').val(userData.phone);
            $('input[name="bank_iban_number"]').val(userData.bank_iban_number);
        });



        $(document).on('submit', '#settlementForm', function (e){
            e.preventDefault();

            var formData = new FormData($(this)[0]);

            console.log(formData);

           $.ajax({
                url: '{{ route('admin.delegates.post.settlement') }}',
                method: 'post',
                data: formData,
                dataType:'json',
                processData: false,
                contentType: false,
                success: function(response) {

                    if(response.key == 'fail'){
                        Swal.fire({
                            position: 'top-center',
                            type: 'error',
                            title: response.msg,
                            showConfirmButton: true,
                            timer: 10000,
                            confirmButtonClass: 'btn btn-primary',
                            buttonsStyling: false,
                        })
                    }else {
                        Swal.fire({
                            position: 'top-center',
                            type: 'success',
                            title: response.msg,
                            showConfirmButton: true,
                            timer: 10000,
                            confirmButtonClass: 'btn btn-primary',
                            buttonsStyling: false,
                        })

                        location.reload();


                    }


                },
                error: function(xhr) {
                    Swal.fire({
                        position: 'top-center',
                        type: 'error',
                        title: '{{ awtTrans('عذراًً يوجد خطأ ما !!!') }}',
                        showConfirmButton: true,
                        timer: 10000,
                        confirmButtonClass: 'btn btn-primary',
                        buttonsStyling: false,
                    })
                },
            });

        });


        $("#end_date").change(function() {
            var startDate = document.getElementById("start_date").value;
            var endDate = document.getElementById("end_date").value;

            if ((Date.parse(endDate) < Date.parse(startDate))) {
                alert("{{ awtTrans('يجب ان يكون تاريخ النهاية بعد تاريخ البداية') }}");
                document.getElementById("end_date").value = "";
            }
        });
        $("#start_date").change(function() {
            var endDate = document.getElementById("end_date").value;
            var startDate = document.getElementById("start_date").value;

            if ((Date.parse(startDate) > Date.parse(endDate))) {
                alert("{{ awtTrans('يجب ان يكون تاريخ البداية قبل تاريخ النهاية') }}");
                document.getElementById("start_date").value = "";
            }
        });
    </script>



@endsection
