@extends('admin.layout.master')

@section('content')
    <!-- // Basic multiple Column Form section start -->
    <section id="multiple-column-form">
        <div class="row match-height">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{awtTrans('عرض طلب تعديل مقدم خدمه ')}}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <form class="store form-horizontal">
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="imgMontg col-12 text-center">
                                                <div class="dropBox">
                                                    <div class="textCenter">
                                                        <div class="imagesUploadBlock">
                                                            <label class="uploadImg">
                                                                <span><i class="feather icon-image"></i></span>
                                                                <input type="file"
                                                                       accept="image/*"
                                                                       name="avatar"
                                                                       class="imageUploader">
                                                            </label>
                                                            <div class="uploadedBlock">
                                                                <img src="{{asset('assets/uploads/users/'.$row->avatar)}}">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <span>{{awtTrans('صورة')}}</span>
                                                </div>
                                            </div>
                                        </div>
                                        @if($row->commercial_image!='default.png')
                                            <div class="col-6">
                                                <div class="imgMontg col-12 text-center">
                                                    <div class="dropBox">
                                                        <div class="textCenter">
                                                            <div class="imagesUploadBlock">
                                                                <label class="uploadImg">
                                                                    <span><i class="feather icon-image"></i></span>
                                                                    <input type="file"
                                                                           accept="image/*"
                                                                           name="commercial_image"
                                                                           class="imageUploader">
                                                                </label>
                                                                <div class="uploadedBlock">
                                                                    <img src="{{asset('assets/uploads/users/'.$row->commercial_image)}}">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <span>{{awtTrans('صورة السجل التجاري ')}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('اسم الشركه')}}</label>
                                                    <div class="controls">
                                                        <input type="text"
                                                               name="name"
                                                               class="form-control"
                                                               value="{{$row->name}}"
                                                               placeholder="{{awtTrans('اكتب الاسم')}}"
                                                               required
                                                               data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                    </div>
                                                </div>
                                            </div>

                                            {{--                                        <div class="col-md-6 col-12">--}}
                                            {{--                                            <div class="form-group">--}}
                                            {{--                                                <label for="first-name-column">{{awtTrans('رقم الجوال')}}</label>--}}
                                            {{--                                                <div class="controls">--}}
                                            {{--                                                    <select style="width: 20% ; position: absolute; left: 3%;"--}}
                                            {{--                                                            name="country_key"--}}
                                            {{--                                                            class="select2 form-control"--}}
                                            {{--                                                            required--}}
                                            {{--                                                            data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">--}}
                                            {{--                                                        @foreach ($keys as $key)--}}
                                            {{--                                                            <option {{$key->calling_code == $row->country_key ? 'selected' : ''}} value="{{$key->calling_code}}">{{$key->calling_code}}</option>--}}
                                            {{--                                                        @endforeach--}}
                                            {{--                                                    </select>--}}
                                            {{--                                                    <input type="number"--}}
                                            {{--                                                           name="phone"--}}
                                            {{--                                                           class="form-control"--}}
                                            {{--                                                           value="{{ '0' . $row->phone}}"--}}
                                            {{--                                                           placeholder="{{awtTrans('اكتب رقم الجوال')}}"--}}
                                            {{--                                                           required--}}
                                            {{--                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">--}}
                                            {{--                                                </div>--}}

                                            {{--                                            </div>--}}
                                            {{--                                        </div>--}}

                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('البريد الالكتروني')}}</label>
                                                    <div class="controls">
                                                        <input type="email"
                                                               name="email"
                                                               class="form-control"
                                                               value="{{$row->email}}"
                                                               placeholder="{{awtTrans('اكتب البريد الالكتروني')}}"
                                                               required
                                                               data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                    </div>
                                                </div>
                                            </div>

                                            {{--                                        <div class="col-md-6 col-12">--}}
                                            {{--                                            <div class="form-group">--}}
                                            {{--                                                <label for="first-name-column">{{awtTrans('كلمة السر')}}</label>--}}
                                            {{--                                                <div class="controls">--}}
                                            {{--                                                    <input type="password"--}}
                                            {{--                                                           name="password"--}}
                                            {{--                                                           class="form-control">--}}
                                            {{--                                                </div>--}}
                                            {{--                                            </div>--}}
                                            {{--                                        </div>--}}


                                            @if($row->commercial_number!=Null)
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('رقم السجل التجاري')}}</label>
                                                    <div class="controls">
                                                        <input type="text"
                                                               name="commercial_number"
                                                               id="commercial_number"
                                                               class="form-control"
                                                               value="{{$row->commercial_number}}"
                                                               required
                                                               data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('رقم الحساب البنكي ')}}</label>
                                                    <div class="controls">
                                                        <input type="text"
                                                               name="bank_account_number"
                                                               id=""
                                                               value="{{$row->bank_account_number}}"
                                                               class="form-control"
                                                               required
                                                               data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('المدينة')}}</label>
                                                    <div class="controls">
                                                        <select name="city_id"
                                                                class="select2 form-control"
                                                                required
                                                                data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                            <option value>{{awtTrans('اختر المدينه')}}</option>
                                                            @foreach ($cities as $city)
                                                                <option {{$city->id == $row->city_id ? 'selected' : ''}} value="{{$city->id}}">{{$city->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                </div>
                                            </div>

                                            {{--                                        <div class="col-md-6">--}}
                                            {{--                                            <div class="form-group">--}}
                                            {{--                                                <label>{{awtTrans('رقم السجل التجاري')}}</label>--}}
                                            {{--                                                <input type="text" name="commercial_number" class="form-control"--}}
                                            {{--                                                       value="{{$row->commercial_number}}"--}}
                                            {{--                                                       required placeholder="{{awtTrans('اكتب رقم السجل التجاري')}}"--}}
                                            {{--                                                       data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">--}}
                                            {{--                                            </div>--}}
                                            {{--                                        </div>--}}

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{awtTrans('رقم الايبان')}}</label>
                                                    <input type="text" name="bank_iban_number" class="form-control"
                                                           required
                                                           value="{{$row->bank_iban_number}}"
                                                           placeholder="{{awtTrans('اكتب رقم الايبان')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{awtTrans('رقم الحساب البنكي')}}</label>
                                                    <input type="number" name="bank_account_number" class="form-control"
                                                           required
                                                           value="{{$row->bank_account_number}}"
                                                           placeholder="{{awtTrans('اكتب رقم الحساب البنكي')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}"
                                                           data-validation-number-message="{{awtTrans('هذا الحقل يجب ان يكون رقما')}}">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{awtTrans('اسم البنك')}}</label>
                                                    <input type="text" name="bank_name" class="form-control" required
                                                           placeholder="{{awtTrans('اكتب اسم البنك')}}"
                                                           value="{{$row->bank_name}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>{{awtTrans('اسم صاحب الحساب')}}</label>
                                                    <input type="text" name="bank_owner_name" class="form-control"
                                                           value="{{$row->bank_owner_name}}"
                                                           required placeholder="{{awtTrans('اكتب اسم صاحب الحساب')}}"
                                                           data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group select-group">
                                                    <label>{{ awtTrans('الجنس') }}</label>
                                                    <select name="gender" class="form-control" required>
                                                        <option>{{$row->gender=='male'?'ذكر':'أنثي'}}</option>
                                                    </select>
                                                    <span class="icon"><i class="bi bi-gender-ambiguous"></i></span>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <h4 class="bold font14">{{ awtTrans('الأقسام الرئيسية') }}</h4>
                                                <ul class="list-group">
                                                    @foreach ($row->categories as $category)
                                                        <li class="list-group-item">
                                                            {{ $category->name }}
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>

                                            {{-- عرض الأقسام الفرعية --}}
                                            <div class="col-md-6">
                                                <h4 class="bold font14">{{ awtTrans('الأقسام الفرعية') }}</h4>
                                                <ul class="list-group">
                                                    @foreach ($row->subcategories as $subcategory)
                                                        <li class="list-group-item">
                                                            {{ $subcategory->name }}
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>

                                            {{-- عرض الخدمات --}}
                                            <div class="col-md-6">
                                                <h4 class="bold font14">{{ awtTrans('الخدمات') }}</h4>
                                                <ul class="list-group">
                                                    @foreach ($row->services as $service)
                                                        <li class="list-group-item">
                                                            {{ $service->name }}
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>

                                            <div class="col-md-12 col-12">
                                                <div class="form-group">
                                                    <label for="first-name-column">{{awtTrans('العنوان ')}}</label>
                                                    <div class="controls">
                                                        <input type="text" value="{{$row->address??''}}" name="address"
                                                               id="address" class="form-control" required
                                                               data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12 col-12 ">
                                                <div class="form-group  pl-5 pr-5 mt-4 position-relative">
                                                    <label for=""
                                                           class="d-block mb-3 siz13 font-weight-bolder">{{awtTrans('تحديد الموقع')}}</label>
                                                    <div class="controls">
                                                        {{-- <input  class="form-control position-absolute w-25" style="z-index: 11111; top:14%; left:7%" id="searchTextField" value="" placeholder="{{awtTrans('تحديد موقعك')}}"> --}}
                                                    </div>
                                                    <div id="map" style="height: 400px; margin-top: 20px">
                                                    </div>
                                                    <input type="hidden" id="lat" name="lat" value="{{$row->lat}}">
                                                    <input type="hidden" id="lng" name="long" value="{{$row->long}}">
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-12 d-flex justify-content-center mt-3">
                                            <a href="{{ url('admin/provider/accept-refuse-update/approved/'.$row->id)}}"
                                               class="btn btn-primary mr-1 mb-1">{{awtTrans('قبول')}}</a>
                                            <a href="{{ url('admin/provider/accept-refuse-update/rejected'.$row->id)}}"
                                               class="btn btn-danger mr-1 mb-1">{{awtTrans('رفض')}}</a>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')
    <script>
        $('.store input').attr('disabled', true)
        $('.store textarea').attr('disabled', true)
        $('.store select').attr('disabled', true)

    </script>
    <script>
        function initMap() {
            // Check if existing coordinates are present in the form fields
            let existingLat = parseFloat(document.getElementById("lat").value);
            let existingLng = parseFloat(document.getElementById("lng").value);

            if (!isNaN(existingLat) && !isNaN(existingLng)) {
                // Use existing coordinates (from the database) if they are available
                const myLatlng = {
                    lat: existingLat,
                    lng: existingLng
                };
                initializeMap(myLatlng);
            } else if (navigator.geolocation) {
                // Fallback to user's current location if no coordinates exist
                navigator.geolocation.getCurrentPosition(function (p) {
                    const myLatlng = {
                        lat: p.coords.latitude,
                        lng: p.coords.longitude
                    };
                    initializeMap(myLatlng);

                    // Set the lat and lng values in the form
                    $('#lat').val(p.coords.latitude);
                    $('#lng').val(p.coords.longitude);

                    // Get the address for the current location
                    GetAddress(new google.maps.LatLng(p.coords.latitude, p.coords.longitude));
                });
            }
        }

        function initializeMap(myLatlng) {
            // Initialize the map centered on the given coordinates
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 18,
                center: myLatlng,
                mapTypeControl: false,
                streetViewControl: false,
            });

            // Set the marker at the given coordinates
            let marker = new google.maps.Marker({
                position: myLatlng,
                map: map,
                title: 'Set lat/lon values for this property',
                draggable: false,
            });
        }

        function GetAddress(latlng) {
            const geocoder = new google.maps.Geocoder();
            geocoder.geocode({'latLng': latlng}, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK && results[1]) {
                    $('#address').val(results[1].formatted_address);
                    $('#searchTextField').val(results[1].formatted_address);
                }
            });
        }

        function geocodeAddress(geocoder, resultsMap) {
            const address = $('#searchTextField').val();
            geocoder.geocode({address: address}, function (results, status) {
                if (status === "OK") {
                    const location = results[0].geometry.location;

                    $('#lat').val(location.lat());
                    $('#lng').val(location.lng());
                    resultsMap.setCenter(location);

                    const marker = new google.maps.Marker({
                        position: location,
                        map: resultsMap,
                        draggable: true,
                    });

                    google.maps.event.addListener(marker, 'dragend', function () {
                        $('#lat').val(this.getPosition().lat());
                        $('#lng').val(this.getPosition().lng());
                    });
                }
            });
        }

        initMap();

    </script>
    <script>

        $(document).ready(function () {
            $('.langs').select2({
                placeholder: "اختار اللغات ",
                allowClear: true,
            });

            $('.places').select2({
                placeholder: "اختار الاماكن ",
                allowClear: true,
            });
            $('.select2-search__field').css('text-align', 'center');

            {{--$(document).on('change', '#city_id', function (e) {--}}
            {{--    e.preventDefault();--}}
            {{--    let cityId = $(this).val();--}}
            {{--    $.ajax({--}}
            {{--        url: "{{route('admin.city.places')}}",--}}
            {{--        method: 'get',--}}
            {{--        data: {city_id: cityId},--}}
            {{--        dataType: 'json',--}}
            {{--        success: function (response) {--}}
            {{--            $('#places').empty();--}}
            {{--            for (place of response.data) {--}}
            {{--                $('#places').append(`<option value="${place.id}">${place.name.{{lang()}}}</option>'`);--}}
            {{--            }--}}
            {{--        },--}}
            {{--    });--}}

            {{--});--}}


        })


        // function changeCountry(){
        //     $('#city_id').html(`
        //         <option value>{{awtTrans('اختر المدينة ')}}</option>
        //     `);
        //     <?php
               //     $selectCountry = '';
               //     if (isset($row->delegateCompany)){
               //         $city = $row->delegateCompany()->first()->city()->first();

               //     }
               //     ?>

        //     var value = $('#country_id').val();
        //     var html = '';


        //     $('#region_id').html(`
        //         <option value>{{awtTrans('اختر المنطقة / المحافظة ')}}</option>
        //         ${html}
        //     `);
        // }

        // changeCountry();

        // $(document).on('change', '#country_id', function (){

        //     changeCountry();

        // });


        // function changeRegion(){
        //     var value = $('#region_id').val();
        //     $.ajax({
        //         url: '{{ route('admin.delegates.getCities') }}',
        //         method: 'post',
        //         data: {
        //             _token:'{{ csrf_token() }}',
        //             region_id: value,
        //             city_id:'{{ isset($city) ? $city['id'] : 0 }}'
        //         },
        //         success: function(response) {

        //             if(response.key == 'success'){
        //                 $('#cities-div').html(`

        //             <div class="form-group" id="">
        //                 <label for="first-name-column">{{awtTrans('المدن ')}}</label>
        //                 <div class="controls">
        //                     <select name="city_id" id="city_id" class="select2 form-control" required data-validation-required-message="{{awtTrans('هذا الحقل مطلوب')}}" >
        //                         ${response.html}

        //                     </select>
        //                 </div>
        //              </div>

        //     `);


        //             }

        //         },
        //         error: function(xhr) {
        //             Swal.fire({
        //                 position: 'top-center',
        //                 type: 'error',
        //                 title: '{{ awtTrans('عذراًً يوجد خطأ ما !!!') }}',
        //                 showConfirmButton: true,
        //                 timer: 10000,
        //                 confirmButtonClass: 'btn btn-primary',
        //                 buttonsStyling: false,
        //             })
        //         },
        //     });

        //     //23944


        // }

        // $(document).on('change', '#region_id', function (){
        //     changeRegion();

        // });

        // changeRegion();


    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAXBff7GujmtnvMARsB5fV2RvUyA6beoII&callback=initMap&language=ar"
            async defer></script>
@endsection
